// *********************************************************************************************************************
//
//	SetImageMask Bug Demo, Paul Robson 3 Feb 2015. Shows effect of copying masks from a 'jigsaw' shaped image 
//	(cutout.png) to/from a simple graphic (picture.png)
//	
//
//	Running AGK2 Alpha 11 (same behaviour in A10), Windows 8.1
//
//	Code is originally from HandsOnAGK Fig 16-22 (pp 460).
//
// *********************************************************************************************************************

SetWindowTitle( "AlphaCopyTest" )										// Set up screen 1024x768
SetWindowSize( 1024, 768, 0 )
SetVirtualResolution( 1024, 768 )

// Set this to 1,2,3 to run the 3 tests.
testType = 1															// Which test : 1,2 or 3.

if testType < 3															// Create image and centre it.												
	LoadImage(1,"picture.png")											
	LoadImage(2,"cutout.png")				
else
	LoadImage(1,"cutout.png")											// 3, we display the cutout and copy RGB to it.
	LoadImage(2,"picture.png")											// should be the same as copying Alpha from the
endif																	// cutout to the picture

CreateSprite(1,1)
SetSpriteSize(1,768,-1)
SetSpriteOffset(1,GetSpriteWidth(1)/2,GetSpriteHeight(1)/2)
SetSpritePositionByOffset(1,512,384)

//
//	Various options - all should show the cutout/jigsaw shape to some degree - test 1 doesn't seem to 
//	be copying the alpha mask, hence it stays as a rectangular picture ?
//
if testType = 1 														// Test 1 copies the alpha mask. Doesn't work.
	SetImageMask(1,2,4,4,0,0)											// should copy the cutout mask to the picture.
endif 																	// e.g. same result as Test # 3

if testType = 2 														// Test 2 copies the red and blue masks
	SetImageMask(1,2,1,1,0,0)											// works showing a purple jigsaw cutout shape.
	SetImageMask(1,2,3,3,0,0)											// picture background is still very recognisable.
endif																	// So, non alpha masks are being copied.

if testType = 3															// Test 3 copies the R,G,B Masks from the picture
	SetImageMask(1,2,1,1,0,0)											// to the cut out, thus you get the cutout
	SetImageMask(1,2,2,2,0,0)											// shape (the alpha) with the picture on it.
	SetImageMask(1,2,3,3,0,0)
endif

repeat																	// Wait for ESC
    Print( ScreenFPS() )
    Sync()
until GetRawKeyState(27) > 0
