--
--	Processor for i8021.def file
--
code = {}
mnemonics = {}
execute = {}

function process(str,offset)
	str = str:gsub("*",("%x"):format(offset))
	return str
end

src = io.open("i8021.def","r")
for l in src:	lines() do		
	if l:match("//") then l = l:match("^(.*)//") end
	l = l:match("^%s*(.*)$"):gsub("%s"," ")
	while l:match(" $") do l = l:sub(1,-2) end
	if #l > 0 then
		if l:match("^%:") then
			code[#code+1] = l:sub(2)
		else
			range,mnemonic,source = l:match('^([%x%-]+)%s+"([%w%@%s%*%,%!%#]+)"%s+(.*)$')
			assert(source ~= nil,l)
			if #range == 2 then range = range.."-"..range end
			first = tonumber(range:sub(1,2),16)
			last = tonumber(range:sub(4,5),16)
			for op = first,last do
				assert(mnemonics[op] == nil,op)
				mnemonics[op] = process(mnemonic,op-first):lower()
				execute[op] = process(source,op-first)
			end
		end
	end
end
src:close()

hCode = io.open("code80.h","w")
for _,l in ipairs(code) do hCode:write(l.."\n") end
hCode:close()

for i = 0,255 do mnemonics[i] = mnemonics[i] or "" end

hMnemonics = io.open("mnemonics80.h","w")
mnelist = '"'..table.concat(mnemonics,'","',0,255)..'"'
hMnemonics:write("static char *_mnemonics[256] = { "..mnelist.."};")
hMnemonics:close()

hCase = io.open("opcodes80.h","w")
for i = 0,255 do
	if execute[i] ~= nil then
		hCase:write(("case 0x%02x: /* %s */\n"):format(i,mnemonics[i]))
		hCase:write("    " .. execute[i]..";break;\n")
	end
end
hCase:close()