--
--	Processor for tms1100.def file
--
code = {}
mnemonics = {}
execute = {}

reverse = { 8,4,12,2,10,6,14,1,9,5,13,3,11,7,15 } reverse[0] = 0
reverse3 = { 4,2,6,1,5,3,7 } reverse3[0] = 0
reverse2 = { 2,1,3} reverse2[0] = 0

function process(str,offset)
	str = str:gsub("@X",("%x"):format(offset))
	str = str:gsub("@M","dataMemory[(x << 4)|y]")
	str = str:gsub("@R",("%x"):format(reverse[offset%16]))
	str = str:gsub("@S",("%x"):format(reverse3[offset%8]))
	str = str:gsub("@B",("%x"):format(reverse2[offset%4]))
	str = str:gsub("@C",("%d"):format(reverse[offset%16]+1))
	return str
end

src = io.open("tms1100.def","r")
for l in src:	lines() do		
	if l:match("//") then l = l:match("^(.*)//") end
	l = l:match("^%s*(.*)$"):gsub("%s"," ")
	while l:match(" $") do l = l:sub(1,-2) end
	if #l > 0 then
		if l:match("^%:") then
			code[#code+1] = l:sub(2)
		else
			range,mnemonic,source = l:match('^([%x%-]+)%s+"([%w%@%s]+)"%s+(.*)$')
			assert(source ~= nil)
			if #range == 2 then range = range.."-"..range end
			first = tonumber(range:sub(1,2),16)
			last = tonumber(range:sub(4,5),16)
			for op = first,last do
				assert(mnemonics[op] == nil,op)
				mnemonics[op] = process(mnemonic,op-first):lower()
				execute[op] = process(source,op-first)
			end
		end
	end
end
src:close()
mnemonics[0x70] = "iac"
mnemonics[0x77] = "dan"

hCode = io.open("code11.h","w")
for _,l in ipairs(code) do hCode:write(l.."\n") end
hCode:close()

hMnemonics = io.open("mnemonics11.h","w")
mnelist = '"'..table.concat(mnemonics,'","',0,255)..'"'
hMnemonics:write("static char *_mnemonics[256] = { "..mnelist.."};")
hMnemonics:close()

hCase = io.open("opcodes11.h","w")
for i = 0,255 do
	hCase:write(("case 0x%02x: /* %s */\n"):format(i,mnemonics[i]))
	hCase:write("    " .. execute[i]..";break;\n")
end
hCase:close()