//
//			Test program
//
//			Implement Keyboard, 
//			Implement Audio
//			Audio automatic (attach to UpdateDisplay ?)
//
NotDataClock = 7
LatchPulse = 6

KeyLeftCol = 8
KeyMiddleCol = 9
KeyRightCol = 10

	lcall 	LCDInitialise

	tcy 	KeyRightCol
	setr

newFrame
	lcall	BumpCounter
	lcall	SwitchPolarity

	cla
	lcall 	WriteBitsA
	tka
	lcall 	WriteBitsA
	lcall 	UpdateDisplay

	cla
	ac1ac
line
	tcy 	15
	tam
	lcall 	WriteBitsM
	tcy 	15
	lcall 	WriteBitsM

	lcall 	UpdateDisplay
	tcy 	15
	imac
	br 		newFrame
	br 		line

	page 	

//
//	Mandatory LCD Setup Code. Installs the table at M(0,0) for bit lookup, resets the line values on !DC and LP.
//

LCDInitialise
	ldx		0 													// Set up the bit table at M(0,0)
	tcy 	0
	tcmiy	1
	tcmiy	2
	tcmiy	4
	tcmiy	8

	tcy		NotDataClock										// 	set !dataclock 1, latch pulse 0
	setr
	tcy 	LatchPulse
	rstr

	retn
//
//	Call to switch polarity. Leaves !DC = 0 on exit, so that the next word latch (a rising edge on !DC) clocks in the data
//	at the right time - setting it back to 1 would cause a clock here.
//

SwitchPolarity
	tcy 	LatchPulse											// On Entry, !DC = 1, LP = 0
	setr														// !DC = 1, LP = 1 - copies the addressed latches to the holding latches (no effect)
	tcy		NotDataClock 										// set !dataclock to 0
	rstr
	tcy 	LatchPulse 											// Falling Edge on Latch Pulse with !DC = 0, toggles polarity
	rstr
	retn 														// Leave !DC = 0 for latching next word.

//
//	Copy addressed latches to holding latches, updating the display
//

UpdateDisplay
	tcy 	4
	tma
	ac8ac
	tam
	tcy 	0
	rstr
	ac8ac
	br 		SkipSound
	setr
SkipSound
	tcy 	LatchPulse
	setr
	rstr
	retn

//
//	Output a bit position to the LCD Driver, either row or column. There are four near identical subroutines, which output
//	M(M(XY)), M(XY), Y or A. It converts the value to a sequence of nibbles with the nth bit set, (where 0 is the left most bit/upper bit)
//
//	Four phases - it one's complements the position so 15 is now the left most
//				- it outputs zeros before the position
//				- it outputs the bit pattern at the position
//				- it outputs the bit pattern after the position
//
//	Requires a table at (X0) to contain 1,2,4,8 (bit lookup)
//	Uses (X7) as temporary storage - this is used for efficiency (so we don't keep changing Y)
//

WriteBitsM 														// Position in M(XY)
	tmy 
WriteBitsY														// Position in Y
	tya 
WriteBitsA 														// A = 0..15, Bit position (15 = right most)
	cpaiz														// Invert A so that 15 is now the left most pixel.	
	dan 
	tcy 	NotDataClock 										// Y = Not Data Clock
	tam 														// Save to 0:NotDataClock
	cla
	tdo 														// set the output lines to $00.
	tma 														// Restore the value.

WBStart
	ac4ac 														// Add 4 to the Bit position - if 12..15 (e.g. the right position),status will be set and it will be 0..3
	br 		WBEndStart 
	rstr 														// Pulse Not(Data Clock) to write out leading zero nibbles.
	setr
	br 		WBStart

WBEndStart 														
	tay															// Point to the look up table
	tma 														// Read it to get the nibble to write
	tdo 														// Write to the O lines
	tcy 	NotDataClock 										// Pulse the not data clock to write it out.
	rstr 									
	setr

	cla															// Clear the O line again
	tdo 
	tma 														// Read the original value back (e.g. the value at the start)
WBEnd
	ac12ac 														// Subtract 4. Status set if value was >= 4
	br 		WBEndNibble 										// so output one zero nibble
	retn 														
WBEndNibble
	rstr 														// Pulse the not data clock line
	setr
	br 		WBEnd 												// And try it again.

	page

//
//	Up counter in Bank 1.
//
BumpCounter
	ldx		1
nextdigit
	tcy 	0										// point to start
carryforward 									 								
	imac 											// increment and load digit
	tam 											// write it back
	ac6ac 											// add 6
	br		carryout 								// if carry set, then carry out
	ldx		0
	retn

carryout
	cla 											// clear the current one
	tam 
	iyc 											// increment Y
	cla 											// in case of carry out, unlikely !
	br 		carryforward


